/*
Trims the text; what is trimmed depends on what's passed in via XML

action.setup:
	- input (string): what should be trimmed:
	  * undefined (default): falls back to alternate
	  * 'selection': ignores lines if they exist, just trims selection
	  * 'selected_lines': each line in the selection
	- alternate (string): what to fall back on
	  * undefined (default): does nothing if input is blank
	  * 'line': will trim the line the caret is on
	  * 'all_lines': will trim all lines in the document
	- trim (string): dictates what part of the text should be trimmed
	  * 'both' (default)
	  * 'start'
	  * 'end'
	- respectIndent (bool): whether or not indent characters (as defined in prefs) should be left untouched
	- trimEmpty (bool): if true, empty lines will have all whitespace stripped, even if it is indentation
*/

var utils = loadLibrary('tea-utils');

action.performWithContext = function(context, outError) {
	// Since input is always a selection of some kind, see if we have one
	var ranges = context.selectedRanges;
	var insertions = new CETextRecipe();
	// Setup our defaults
	var targetSide = (action.setup.trim ? action.setup.trim.toLowerCase() : 'both');
	var respectIndent = (typeof action.setup.respectIndent !== 'undefined' ? action.setup.respectIndent : false);
	var preserveLinebreaks = (typeof action.setup.preserveLinebreaks !== 'undefined' ? action.setup.preserveLinebreaks : true);
	var trimEmpty = (typeof action.setup.trimEmpty !== 'undefined' ? action.setup.trimEmpty : false);
	var text = '';
	var range;
	// Check to see if we have any input (that is, have a selection)
	if (!action.setup.input || (ranges.length === 1 && ranges[0].length === 0)) {
		if (action.setup.alternate) {
			var alternate = action.setup.alternate.toLowerCase();
			range = ranges[0];
			if (alternate === 'line') {
				// Grab the range and text for the current line
				range = context.lineStorage.lineRangeForIndex(range.location);
				text = context.string.substringWithRange(range);
				// Trim it!
				text = utils.trim(context, text, false, targetSide, respectIndent, preserveLinebreaks, trimEmpty);
			} else if (alternate === 'all_lines') {
				// Grab the document's range and text
				range = new Range(0, context.string.length);
				text = context.string;
				// Trim it!
				text = utils.trim(context, text, true, targetSide, respectIndent, preserveLinebreaks, trimEmpty);
			}
			// Add the new text to our recipe
			insertions.replaceRange(range, text);
		} else {
			// No input, no alternate; something went wrong
			return false;
		}
	} else {
		// Check to see if we need to parse lines or not
		var parseLines = false;
		if (action.setup.input.toLowerCase() === 'selected_lines') {
			parseLines = true;
		}
		// Loop through all of our selections
		var count = ranges.length;
		for (var i = 0; i < count; i++) {
			// Grab our range and text
			range = ranges[i];
			text = context.string.substringWithRange(range);
			// Trim it
			text = utils.trim(context, text, parseLines, targetSide, respectIndent, preserveLinebreaks, trimEmpty);
			// Add to recipe
			insertions.replaceRange(range, text);
		}
	}
	
	// Run the recipe!
	return context.applyTextRecipe(insertions);
}
